package com.coolerpromc.arrowplus.arrow;

import com.coolerpromc.arrowplus.item.custom.ModFeatherItem;
import com.coolerpromc.arrowplus.item.custom.ModStickItem;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ArrowData(Either<class_6880<class_1792>, class_6862<class_1792>> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects, class_6880<class_1792> feather, class_6880<class_1792> stick, int outputAmount) {
    public ArrowData(class_1792 material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects) {
        this(Either.left(material.method_40131()), baseDamage, color, translationKey, flame, gravity, effects, class_1802.field_8153.method_40131(), class_1802.field_8600.method_40131(), 4);
    }

    public ArrowData(class_6862<class_1792> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects) {
        this(Either.right(material), baseDamage, color, translationKey, flame, gravity, effects, class_1802.field_8153.method_40131(), class_1802.field_8600.method_40131(), 4);
    }

    public ArrowData(class_1792 material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects, class_1792 feather, class_1792 stick, int outputAmount) {
        this(Either.left(material.method_40131()), baseDamage, color, translationKey, flame, gravity, effects, feather.method_40131(), stick.method_40131(), outputAmount);
    }

    public ArrowData(class_6862<class_1792> material, double baseDamage, int color, String translationKey, boolean flame, double gravity, Map<class_2960, Integer> effects, class_1792 feather, class_1792 stick, int outputAmount) {
        this(Either.right(material), baseDamage, color, translationKey, flame, gravity, effects, feather.method_40131(), stick.method_40131(), outputAmount);
    }

    public boolean isValidMaterial(class_1799 materialStack, class_1799 stickStack, class_1799 featherStack){
        if (material.left().isPresent() && materialStack.method_41406(material.left().get())){
            return stickStack.method_41406(stick) && featherStack.method_41406(feather);
        }
        else if (material.right().isPresent() && materialStack.method_31573(material.right().get())){
            return stickStack.method_41406(stick) && featherStack.method_41406(feather);
        }
        else {
            return false;
        }
    }

    public static final Codec<Either<class_6880<class_1792>, class_6862<class_1792>>> MATERIAL_CODEC = Codec.either(
            class_1792.field_54952,
            class_6862.method_40093(class_7924.field_41197)
    );

    public static final class_9139<class_9129, Either<class_6880<class_1792>, class_6862<class_1792>>> MATERIAL_STREAM_CODEC = class_9135.method_57995(
            class_1792.field_55708,
            class_6862.method_64143(class_7924.field_41197)
    );

    public static final Codec<ArrowData> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            MATERIAL_CODEC.fieldOf("material").forGetter(ArrowData::material),
            Codec.DOUBLE.fieldOf("baseDamage").forGetter(ArrowData::baseDamage),
            Codec.INT.fieldOf("color").forGetter(ArrowData::color),
            Codec.STRING.fieldOf("translationKey").forGetter(ArrowData::translationKey),
            Codec.BOOL.fieldOf("flame").forGetter(ArrowData::flame),
            Codec.DOUBLE.fieldOf("gravity").forGetter(ArrowData::gravity),
            Codec.unboundedMap(class_2960.field_25139, Codec.INT).fieldOf("effects").forGetter(ArrowData::effects),
            class_1792.field_54952.fieldOf("feather").validate(itemHolder -> itemHolder.method_55838(class_1802.field_8153.method_40131()) || itemHolder.comp_349() instanceof ModFeatherItem ? DataResult.success(itemHolder) : DataResult.error(() -> "Item must be vanilla feather or feather from Arrow+ mod.")).forGetter(ArrowData::feather),
            class_1792.field_54952.fieldOf("stick").validate(itemHolder -> itemHolder.method_55838(class_1802.field_8600.method_40131()) || itemHolder.comp_349() instanceof ModStickItem ? DataResult.success(itemHolder) : DataResult.error(() -> "Item must be vanilla stick or stick from Arrow+ mod.")).forGetter(ArrowData::stick),
            Codec.INT.fieldOf("outputAmount").forGetter(ArrowData::outputAmount)
    ).apply(instance, ArrowData::new));

    public static final class_9139<class_9129, ArrowData> STREAM_CODEC = class_9139.method_74966(
            MATERIAL_STREAM_CODEC,
            ArrowData::material,
            class_9135.field_48553,
            ArrowData::baseDamage,
            class_9135.field_49675,
            ArrowData::color,
            class_9135.field_48554,
            ArrowData::translationKey,
            class_9135.field_48547,
            ArrowData::flame,
            class_9135.field_48553,
            ArrowData::gravity,
            class_9135.method_56377(HashMap::new, class_2960.field_48267, class_9135.field_49675),
            ArrowData::effects,
            class_1792.field_55708,
            ArrowData::feather,
            class_1792.field_55708,
            ArrowData::stick,
            class_9135.field_49675,
            ArrowData::outputAmount,
            ArrowData::new
    );

    public static final ArrowData EMPTY = new ArrowData(class_1802.field_8162, 0.0, 0xFF141414, "item.arrowplus.cheated_item", false, 0.05, Map.of());
}
