package com.coolerpromc.arrowplus.compat.rei;

import com.coolerpromc.arrowplus.ArrowPlus;
import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.recipe.ArrowRecipe;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ArrowRecipeFiller implements Function<class_8786<ArrowRecipe>, Collection<Display>> {
     public void registerDisplays(ServerDisplayRegistry registry) {
        registry.beginRecipeFiller(getRecipeClass())
                .filterType(class_3956.field_17545)
                .fillMultiple(this);
    }

    Class<ArrowRecipe> getRecipeClass(){
         return ArrowRecipe.class;
    }

    @Override
    public Collection<Display> apply(class_8786<ArrowRecipe> recipeHolder) {
        List<Display> displays = new ArrayList<>();

        BasicDisplay.registryAccess().method_30530(ModRegistries.ARROW_DATA_KEY).method_42017().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.method_40237().method_29177().method_12832())).forEach(data -> {
            class_1856 ingredient = class_1856.method_8101(class_1802.field_8145);
            class_2960 materialLocation = class_2960.method_60654("invalid");
            class_1799 output = new class_1799(ModItems.ARROW_PLUS, data.comp_349().outputAmount());
            output.method_57379(ModDataComponents.ARROW_DATA, data);

            if (data.comp_349().material().left().isPresent()){
                ingredient = class_1856.method_8101(data.comp_349().material().left().get().comp_349());
                materialLocation = data.comp_349().material().left().get().method_40230().get().method_29177();
            }
            else if (data.comp_349().material().right().isPresent()){
                ingredient = class_1856.method_8106(class_7923.field_41178.method_46735(data.comp_349().material().right().get()));
                materialLocation = data.comp_349().material().right().get().comp_327();
            }

            class_2960 id = class_2960.method_60655(ArrowPlus.MODID, "arrowplus.arrow." + materialLocation.method_12832());

            List<EntryIngredient> inputEntries = List.of(
                    EntryIngredient.empty(),
                    EntryIngredients.ofIngredient(ingredient),
                    EntryIngredient.empty(),
                    EntryIngredient.empty(),
                    EntryIngredients.of(data.comp_349().stick().comp_349()),
                    EntryIngredient.empty(),
                    EntryIngredient.empty(),
                    EntryIngredients.of(data.comp_349().feather().comp_349()),
                    EntryIngredient.empty()
            );
            displays.add(new DefaultCustomDisplay(inputEntries, List.of(EntryIngredients.of(output)), Optional.of(id)));

            BasicDisplay.registryAccess().method_30530(class_7924.field_41215).method_42017().forEach(potion -> {
                if (!potion.comp_349().method_8049().isEmpty()) {
                    class_1799 arrow = output.method_46651(1);
                    class_1799 lingeringPotion = new class_1799(class_1802.field_8150.method_40131(), 1, class_9326.method_57841().method_57854(class_9334.field_49651, new class_1844(potion)).method_57852());
                    class_1799 tippedOutput = arrow.method_7972();
                    tippedOutput.method_57379(class_9334.field_49651, new class_1844(potion));

                    class_2960 loc = class_2960.method_60655(ArrowPlus.MODID, "arrowplus.arrow." + arrow.method_41409().method_40230().get().method_29177().method_12832() + "." + potion.method_40230().get().method_29177().method_12832());

                    List<EntryIngredient> tippedInputs = List.of(
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(lingeringPotion)),
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(arrow)),
                            EntryIngredient.of(EntryStacks.of(arrow))
                    );

                    displays.add(new DefaultCustomDisplay(tippedInputs, List.of(EntryIngredients.of(tippedOutput)), Optional.of(loc)));
                }
            });
        });
        return displays;
    }
}
