package com.coolerpromc.arrowplus.datagen;

import com.coolerpromc.arrowplus.ArrowPlus;
import com.coolerpromc.arrowplus.datagen.model.*;
import com.coolerpromc.arrowplus.item.ModItems;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10396;
import net.minecraft.class_10404;
import net.minecraft.class_10410;
import net.minecraft.class_10437;
import net.minecraft.class_10439;
import net.minecraft.class_10485;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;
import net.minecraft.client.data.*;

public class ModModelProvider extends FabricModelProvider {
    public static final class_4945 LAYER3 = class_4945.method_27043("layer3");
    public static final class_4942 FOUR_LAYERED_ITEM = class_4943.method_25859("generated", class_4945.field_23006, class_4945.field_42089, class_4945.field_42234, LAYER3);

    public ModModelProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {

    }

    @Override
    public void generateItemModels(class_4915 itemModels) {
        // Arrows
        generateArrow(itemModels, ModItems.ARROW_PLUS);

        // Sticks
        itemModels.field_55245.method_75343(ModItems.COPPER_STICK, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.COPPER_STICK, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/stick")), itemModels.field_55246), new StickTintSource(-1)));
        itemModels.field_55245.method_75343(ModItems.IRON_STICK, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.IRON_STICK, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/stick")), itemModels.field_55246), new StickTintSource(-1)));
        itemModels.field_55245.method_75343(ModItems.GOLD_STICK, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.GOLD_STICK, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/stick")), itemModels.field_55246), new StickTintSource(-1)));
        itemModels.field_55245.method_75343(ModItems.DIAMOND_STICK, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.DIAMOND_STICK, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/stick")), itemModels.field_55246), new StickTintSource(-1)));
        itemModels.field_55245.method_75343(ModItems.EMERALD_STICK, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.EMERALD_STICK, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/stick")), itemModels.field_55246), new StickTintSource(-1)));
        itemModels.field_55245.method_75343(ModItems.NETHERITE_STICK, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.NETHERITE_STICK, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/stick")), itemModels.field_55246), new StickTintSource(-1)));

        // Feather
        itemModels.field_55245.method_75343(ModItems.GILDED_FEATHER, class_10410.method_65483(class_4943.field_22938.method_48525(ModItems.GILDED_FEATHER, class_4944.method_25895(class_2960.method_60655(ArrowPlus.MODID, "item/feather")), itemModels.field_55246), new FeatherTintSource(-1)));

        // Vanilla override
        itemModels.field_55245.method_75343(class_1802.field_8107, class_10410.method_65481(class_4943.field_22938.method_25852(class_4944.method_25876(class_1802.field_8107), class_4944.method_25895(getModelLocation(class_1802.field_8107, "")), itemModels.field_55246)));
        generateBow(itemModels, class_1802.field_8102);
    }

    private void generateArrow(class_4915 itemModels, class_1792 item) {
        class_4944 baseMapping = new class_4944()
                .method_25868(class_4945.field_23006, ArrowPlus.id("item/arrow_stick"))
                .method_25868(class_4945.field_42089, ArrowPlus.id("item/arrow_head"))
                .method_25868(class_4945.field_42234, ArrowPlus.id("item/arrow_feather"));

        class_4944 tippedMapping = new class_4944()
                .method_25868(class_4945.field_23006, ArrowPlus.id("item/arrow_stick"))
                .method_25868(class_4945.field_42089, ArrowPlus.id("item/arrow_head"))
                .method_25868(class_4945.field_42234, ArrowPlus.id("item/arrow_feather"))
                .method_25868(LAYER3, ArrowPlus.id("item/arrow_tipped"));

        class_2960 base = class_4943.field_42233.method_25852(getModelLocation(item, ""), baseMapping, itemModels.field_55246);
        class_2960 tipped = FOUR_LAYERED_ITEM.method_25852(getModelLocation(item, "_tipped"), tippedMapping, itemModels.field_55246);

        itemModels.field_55245.method_75343(item, new class_10437.class_10438(
                new TippedCondition(),
                class_10410.method_65483(tipped, new StickTintSource(-1), new ArrowTintSource(0xFFFFFFFF), new FeatherTintSource(-1), new class_10404(-1)),
                class_10410.method_65483(base, new StickTintSource(-1), new ArrowTintSource(0xFFFFFFFF), new FeatherTintSource(-1)))
        );
    }

    public void generateBow(class_4915 itemModels, class_1792 bowItem) {
        class_10439.class_10441 itemmodel$unbaked = class_10410.method_65481(class_4941.method_25840(bowItem));
        class_10439.class_10441 itemmodel$unbaked1 = class_10410.method_65483(this.createLayeredItemModel(itemModels, bowItem, "_pulling_0"), new class_10396(-1), new BowTintSource(-1), new BowStickTintSource(0xFF886627));
        class_10439.class_10441 itemmodel$unbaked2 = class_10410.method_65483(this.createLayeredItemModel(itemModels, bowItem, "_pulling_1"), new class_10396(-1), new BowTintSource(-1), new BowStickTintSource(0xFF886627));
        class_10439.class_10441 itemmodel$unbaked3 = class_10410.method_65483(this.createLayeredItemModel(itemModels, bowItem, "_pulling_2"), new class_10396(-1), new BowTintSource(-1), new BowStickTintSource(0xFF886627));
        itemModels.field_55245.method_75343(
                bowItem,
                class_10410.method_65487(class_10410.method_65479(), class_10410.method_65488(new class_10485(false), 0.05F, itemmodel$unbaked1, class_10410.method_65486(itemmodel$unbaked2, 0.65F), class_10410.method_65486(itemmodel$unbaked3, 0.9F)), itemmodel$unbaked));
    }

    private class_2960 createLayeredItemModel(class_4915 itemModels, class_1792 item, String suffix) {
        return class_4943.method_25859("bow", class_4945.field_23006, class_4945.field_42089, class_4945.field_42234).method_25852(class_4944.method_25863(item, suffix), class_4944.method_48745(getModelLocation(item, suffix), getModelLocation(item, suffix + "_head"), getModelLocation(item, suffix + "_stick")), itemModels.field_55246);
    }

    private class_2960 getModelLocation(class_1792 item, String suffix) {
        return class_2960.method_60655(ArrowPlus.MODID, "item/" + class_7923.field_41178.method_10221(item).method_12832() + suffix);
    }
}
