package com.coolerpromc.arrowplus.datagen;

import com.coolerpromc.arrowplus.ArrowPlus;
import com.coolerpromc.arrowplus.arrow.ArrowData;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.item.custom.ModStickItem;
import com.coolerpromc.arrowplus.recipe.ArrowRecipe;
import com.coolerpromc.arrowplus.recipe.TippedArrowRecipe;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.coolerpromc.fletchingrecipe.datagen.recipebuilder.FletchingRecipeBuilder;
import com.coolerpromc.fletchingrecipe.util.SizedIngredient;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2066;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2456;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.minecraft.class_9326;
import java.util.concurrent.CompletableFuture;

public class ModRecipeProvider extends FabricRecipeProvider {
    public ModRecipeProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(dataOutput, completableFuture);
    }

    @Override
    protected class_2446 method_62766(class_7225.class_7874 wrapperLookup, class_8790 recipeExporter) {
        final class_7871<class_1792> items = wrapperLookup.method_46762(class_7924.field_41197);
        
        return new class_2446(wrapperLookup, recipeExporter) {
            @Override
            public void method_10419() {
                class_2456.method_10476(ArrowRecipe::new).method_10475(this.field_53721, class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(ArrowPlus.MODID, "arrow_recipe")));
                class_2456.method_10476(TippedArrowRecipe::new).method_10475(this.field_53721, class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(ArrowPlus.MODID, "tipped_arrow_recipe")));

                stickRecipe(class_1802.field_27022, ModItems.COPPER_STICK);
                stickRecipe(class_1802.field_8620, ModItems.IRON_STICK);
                stickRecipe(class_1802.field_8695, ModItems.GOLD_STICK);
                stickRecipe(class_1802.field_8477, ModItems.DIAMOND_STICK);
                stickRecipe(class_1802.field_8687, ModItems.EMERALD_STICK);
                stickRecipe(class_1802.field_22020, ModItems.NETHERITE_STICK);

                class_2447.method_10436(items, class_7800.field_40642, ModItems.GILDED_FEATHER, 4)
                        .method_10439(" G ")
                        .method_10439("GFG")
                        .method_10439(" G ")
                        .method_10434('G', class_1802.field_8601)
                        .method_10434('F', class_1802.field_8153)
                        .method_10429(method_32807(class_1802.field_8601), method_10426(class_1802.field_8601))
                        .method_10429(method_32807(class_1802.field_8153), method_10426(class_1802.field_8153))
                        .method_10431(field_53721);

                field_48981.method_46762(ModRegistries.ARROW_DATA_KEY).method_42017().forEach(holder -> {
                    ArrowData arrowData = holder.comp_349();
                    class_1856 ingredient = null;
                    class_175<class_2066.class_2068> hasIngredient = null;
                    String hasName = "";
                    if (arrowData.material().left().isPresent()){
                        ingredient = class_1856.method_8101(arrowData.material().left().get().comp_349());
                        hasIngredient = method_10426(arrowData.material().left().get().comp_349());
                        hasName = method_32807(arrowData.material().left().get().comp_349());
                    }
                    else if (arrowData.material().right().isPresent()){
                        ingredient = class_1856.method_8106(items.method_46735(arrowData.material().right().get()));
                        hasIngredient = method_10420(arrowData.material().right().get());
                        hasName = "has_" + arrowData.material().right().get().comp_327().method_12832();
                    }

                    FletchingRecipeBuilder.builder()
                            .top(new SizedIngredient(ingredient, 1))
                            .middle(new SizedIngredient(class_1856.method_8101(arrowData.stick().comp_349()), 1))
                            .bottom(new SizedIngredient(class_1856.method_8101(arrowData.feather().comp_349()), 1))
                            .output(new class_1799(ModItems.ARROW_PLUS.method_40131(), arrowData.outputAmount() * 2, class_9326.method_57841().method_57854(ModDataComponents.ARROW_DATA, holder).method_57852()))
                            .method_33530(hasName, hasIngredient)
                            .method_33530(method_32807(arrowData.stick().comp_349()), method_10426(arrowData.stick().comp_349()))
                            .method_33530(method_32807(arrowData.feather().comp_349()), method_10426(arrowData.feather().comp_349()))
                            .method_17972(withConditions(field_53721, ResourceConditions.allModsLoaded("fletchingrecipe")), class_5321.method_29179(class_7924.field_52178, class_2960.method_60655(ArrowPlus.MODID, "fletching/" + holder.method_40230().get().method_29177().method_12832() + "_arrow")));
                });
            }

            private void stickRecipe(class_1792 item, ModStickItem stickItem) {
                class_2447.method_10436(items, class_7800.field_40642, stickItem, 4)
                        .method_10439("S")
                        .method_10439("S")
                        .method_10428('S', class_1856.method_8101(item))
                        .method_10429(method_32807(item), method_10426(item))
                        .method_10431(field_53721);
            }
        };
    }

    @Override
    public String method_10321() {
        return "Arrow+ Recipes";
    }
}
