package com.coolerpromc.arrowplus.datagen.model;

import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.arrow.ArrowData;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10401;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public record ArrowTintSource(int defaultColor) implements class_10401 {
    public static final MapCodec<ArrowTintSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_5699.field_51365.fieldOf("default").forGetter(ArrowTintSource::defaultColor)
    ).apply(instance, ArrowTintSource::new));

    @Override
    public int method_65389(class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity) {
        class_6880<ArrowData> arrowData = itemStack.method_58694(ModDataComponents.ARROW_DATA);
        if (arrowData != null){
            return class_9848.method_61334(arrowData.comp_349().color());
        }
        return defaultColor;
    }

    @Override
    public MapCodec<? extends class_10401> method_65387() {
        return MAP_CODEC;
    }
}
