package com.coolerpromc.arrowplus.datagen.model;

import com.coolerpromc.arrowplus.arrow.ArrowData;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.custom.ModStickItem;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10401;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jspecify.annotations.Nullable;

public record BowStickTintSource(int defaultColor) implements class_10401 {
    public static final MapCodec<BowStickTintSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.INT.fieldOf("default").forGetter(BowStickTintSource::defaultColor)
    ).apply(instance, BowStickTintSource::new));

    @Override
    public int method_65389(class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity) {
        if (livingEntity != null){
            class_1799 arrowStack = livingEntity.method_18808(itemStack);
            class_6880<ArrowData> data = arrowStack.method_58694(ModDataComponents.ARROW_DATA);
            if (data != null && data.comp_349().stick().comp_349() instanceof ModStickItem item){
                return item.getColor();
            }
            return 0xFF886627;
        }
        return defaultColor;
    }

    @Override
    public MapCodec<? extends class_10401> method_65387() {
        return MAP_CODEC;
    }
}