package com.coolerpromc.arrowplus.datagen.model;

import com.coolerpromc.arrowplus.arrow.ArrowData;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.custom.ModFeatherItem;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10401;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.jspecify.annotations.Nullable;

public record FeatherTintSource(int defaultColor) implements class_10401 {
    public static final MapCodec<FeatherTintSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_5699.field_51365.fieldOf("default").forGetter(FeatherTintSource::defaultColor)
    ).apply(instance, FeatherTintSource::new));

    @Override
    public int method_65389(class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity) {
        if (itemStack.method_57826(ModDataComponents.ARROW_DATA)){
            class_6880<ArrowData> holder = itemStack.method_58694(ModDataComponents.ARROW_DATA);
            ArrowData data = holder.comp_349();
            if (data.feather().comp_349() instanceof ModFeatherItem item){
                return item.getColor();
            }
            return -1;
        }
        if (itemStack.method_7909() instanceof ModFeatherItem item){
            return item.getColor();
        }
        return defaultColor;
    }

    @Override
    public MapCodec<? extends class_10401> method_65387() {
        return MAP_CODEC;
    }
}