package com.coolerpromc.arrowplus.mixin;

import com.coolerpromc.arrowplus.util.InfiniteArrow;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_3902;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1811.class)
public abstract class InfiniteBowMixin {
    @Inject(method = "getProjectile", at = @At("HEAD"), cancellable = true)
    private static void getProjectiles(class_1799 stack, class_1799 projectileStack, class_1309 shooter, boolean multishot, CallbackInfoReturnable<class_1799> cir) {
        if (multishot || shooter instanceof class_1657 player && player.method_68878()) {
            return;
        }

        if (projectileStack.method_7909() instanceof InfiniteArrow arrowItem && arrowItem.isInfinite(projectileStack, stack, shooter)) {
            class_1799 intangible = projectileStack.method_46651(1);
            intangible.method_57379(class_9334.field_49642, class_3902.field_17274);
            cir.setReturnValue(intangible);
        }
    }
}