package com.coolerpromc.arrowplus.recipe;

import com.coolerpromc.arrowplus.arrow.ArrowData;
import com.coolerpromc.arrowplus.config.ArrowPlusConfig;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.item.ModItems;
import com.coolerpromc.arrowplus.registry.ModRegistries;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;

public class ArrowRecipe extends class_1852 {
    public ArrowRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(class_9694 craftingInput, class_1937 level) {
        if (craftingInput.method_59991() == 1 && craftingInput.method_59992() == 3 && craftingInput.method_59990() == 3){
            List<class_6880.class_6883<ArrowData>> arrowDataList = level.method_30349().method_30530(ModRegistries.ARROW_DATA_KEY).method_42017().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.method_40237().method_29177().method_12832())).toList();

            class_1799 materialStack = craftingInput.method_59984(0);
            class_1799 stickStack = craftingInput.method_59984(1);
            class_1799 featherStack = craftingInput.method_59984(2);

            for (class_6880<ArrowData> arrowData : arrowDataList){
                if (arrowData.comp_349().isValidMaterial(materialStack, stickStack, featherStack)){
                    return true;
                }
            }
            return false;
        }
        else {
            return false;
        }
    }

    @Override
    public class_1799 craft(class_9694 craftingInput, class_7225.class_7874 provider) {
        List<Either<class_6880<class_1792>, class_6862<class_1792>>> materialList = new ArrayList<>();
        class_6880<ArrowData> arrowData = null;
        class_1799 materialStack = craftingInput.method_59984(0);

        List<class_6880.class_6883<ArrowData>> arrowDataList = provider.method_46762(ModRegistries.ARROW_DATA_KEY).method_42017().filter(reference -> !ArrowPlusConfig.CONFIG.getRemoval().contains(reference.method_40237().method_29177().method_12832())).toList();
        for (class_6880<ArrowData> holder : arrowDataList){
            materialList.add(holder.comp_349().material());
            if (holder.comp_349().material().left().isPresent() && materialStack.method_41406(holder.comp_349().material().left().get())) {
                arrowData = holder;
            }
            else if (holder.comp_349().material().right().isPresent() && materialStack.method_31573(holder.comp_349().material().right().get())) {
                arrowData = holder;
            }
        }

        if (arrowData != null && materialList.contains(arrowData.comp_349().material())){
            class_1799 stack = new class_1799(ModItems.ARROW_PLUS, arrowData.comp_349().outputAmount());
            stack.method_57379(ModDataComponents.ARROW_DATA, arrowData);
            return stack;
        }
        else{
            return class_1799.field_8037;
        }
    }

    @Override
    public class_1865<? extends class_1852> method_8119() {
        return ModRecipeSerializer.ARROW_RECIPE_SERIALIZER;
    }
}
