/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.arrowplus.entity.custom;

import com.coolerpromc.arrowplus.arrow.ArrowData;
import com.coolerpromc.arrowplus.datacomponent.ModDataComponents;
import com.coolerpromc.arrowplus.entity.ModEntities;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModArrowEntity
extends class_1665 {
    private static final class_2940<ArrowData> ARROW_DATA = class_2945.method_12791(ModArrowEntity.class, ModEntities.ARROW_DATA);
    private static final class_2940<Integer> ID_EFFECT_COLOR = class_2945.method_12791(ModArrowEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> PICKUP_STACK = class_2945.method_12791(ModArrowEntity.class, (class_2941)class_2943.field_13322);

    public ModArrowEntity(class_1299<? extends class_1665> p_331098_, class_1937 p_331626_, class_1799 pickupItemStack) {
        super(p_331098_, p_331626_);
        this.method_57313(pickupItemStack);
        this.updateArrowData();
        this.updateColor();
    }

    public ModArrowEntity(class_1309 owner, class_1937 level, class_1799 pickupItemStack, @Nullable class_1799 firedFromWeapon, double baseDamage) {
        super(ModEntities.ARROW_PLUS, owner, level, pickupItemStack.method_46651(1), firedFromWeapon);
        this.method_57313(pickupItemStack);
        this.field_7572 = class_1665.class_1666.field_7593;
        if (firedFromWeapon != null && firedFromWeapon.method_7909() instanceof class_1753) {
            int infinityLevel;
            int powerLevel = class_1890.method_8225((class_6880)level.method_30349().method_66874(class_1893.field_9103), (class_1799)firedFromWeapon);
            if (powerLevel > 0) {
                baseDamage += baseDamage * 0.25 * (double)(powerLevel + 1);
            }
            this.field_7572 = (infinityLevel = class_1890.method_8225((class_6880)level.method_30349().method_66874(class_1893.field_9125), (class_1799)firedFromWeapon)) > 0 ? class_1665.class_1666.field_7592 : class_1665.class_1666.field_7593;
        }
        this.method_7438(baseDamage);
        this.updateArrowData();
        this.updateColor();
    }

    public ModArrowEntity(double x, double y, double z, class_1937 level, class_1799 pickupItemStack, @Nullable class_1799 firedFromWeapon) {
        super(ModEntities.ARROW_PLUS, x, y, z, level, pickupItemStack, firedFromWeapon);
        this.method_57313(pickupItemStack);
        this.updateArrowData();
        this.updateColor();
    }

    private class_1844 getPotionContents() {
        return (class_1844)((class_1799)this.field_6011.method_12789(PICKUP_STACK)).method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
    }

    private float getPotionDurationScale() {
        return ((Float)((class_1799)this.field_6011.method_12789(PICKUP_STACK)).method_58695(class_9334.field_55879, (Object)Float.valueOf(1.0f))).floatValue();
    }

    protected void method_57313(class_1799 stack) {
        super.method_57313(stack);
        this.updateColor();
        this.field_6011.method_12778(PICKUP_STACK, (Object)stack);
    }

    private void updateColor() {
        class_1844 potioncontents = this.getPotionContents();
        this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)(potioncontents.equals((Object)class_1844.field_49274) ? -1 : potioncontents.method_8064()));
    }

    @NotNull
    protected class_1799 method_57314() {
        return (class_1799)this.field_6011.method_12789(PICKUP_STACK);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ARROW_DATA, (Object)ArrowData.EMPTY);
        builder.method_56912(ID_EFFECT_COLOR, (Object)-1);
        builder.method_56912(PICKUP_STACK, (Object)class_1799.field_8037);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608()) {
            if (this.method_65059()) {
                if (this.field_7576 % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.method_65059() && this.field_7576 != 0 && !this.getPotionContents().equals((Object)class_1844.field_49274) && this.field_7576 >= 600) {
            this.method_73183().method_8421((class_1297)this, (byte)0);
            this.method_57313(new class_1799((class_1935)class_1802.field_8107));
        }
    }

    private void makeParticle(int particleAmount) {
        int i = this.getColor();
        if (i != -1 && particleAmount > 0) {
            for (int j = 0; j < particleAmount; ++j) {
                this.method_73183().method_8406((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)i), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(ID_EFFECT_COLOR);
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71468("arrow_data", ArrowData.CODEC, (Object)this.getArrowData());
        valueOutput.method_71465("color", this.getColor());
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        valueInput.method_71426("arrow_data", ArrowData.CODEC).ifPresent(arrowData -> this.field_6011.method_12778(ARROW_DATA, arrowData));
        this.field_6011.method_12778(ID_EFFECT_COLOR, (Object)valueInput.method_71424("color", -1));
    }

    public void updateArrowData() {
        this.field_6011.method_12778(ARROW_DATA, (Object)((ArrowData)((class_6880)((class_1799)this.field_6011.method_12789(PICKUP_STACK)).method_58695(ModDataComponents.ARROW_DATA, (Object)class_6880.method_40223((Object)ArrowData.EMPTY))).comp_349()));
    }

    public ArrowData getArrowData() {
        return (ArrowData)this.field_6011.method_12789(ARROW_DATA);
    }

    public class_2561 method_5477() {
        return class_2561.method_43471((String)this.getArrowData().translationKey());
    }

    protected double method_7490() {
        return this.getArrowData().gravity();
    }

    protected void method_7450(class_1309 livingEntity) {
        super.method_7450(livingEntity);
        this.getArrowData().effects().forEach((resourceLocation, integer) -> class_7923.field_41179.method_10223(resourceLocation).ifPresent(potionReference -> ((class_1842)potionReference.comp_349()).method_8049().forEach(instance -> livingEntity.method_6092(new class_1293(instance.method_5579(), integer.intValue(), instance.method_5578(), instance.method_5591(), instance.method_5581(), instance.method_5592(), null)))));
        class_1297 entity = this.method_37225();
        class_1844 potioncontents = this.getPotionContents();
        float f = this.getPotionDurationScale();
        potioncontents.method_57402(p_478604_ -> livingEntity.method_37222(p_478604_, entity), f);
    }

    public boolean method_5809() {
        return this.getArrowData().flame() || super.method_5809();
    }

    public void method_5711(byte b) {
        if (b == 0) {
            int i = this.getColor();
            if (i != -1) {
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                for (int j = 0; j < 20; ++j) {
                    this.method_73183().method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)f, (float)f1, (float)f2), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.method_5711(b);
        }
    }
}

